/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.ParameterPanelSourceChangedListener;
import DE.siemens.ad.logo.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ParameterPanel
extends DataInputPanel {
    protected Vector fParameterPanelSourceChangedListeners;
    protected JPanel paramPane;
    protected JPanel globalParamPane;
    protected JPanel actualPane;
    protected JPanel blocknamePanel;
    protected String fPanelName;
    protected Parameter fParameterReference;
    private static final int MINIMAL_HEIGHT = 200;
    private static final int MINIMAL_WIDTH = 300;

    public ParameterPanel() {
    }

    public ParameterPanel(Vector panels, Parameter parameterReference) {
        this.fParameterReference = parameterReference;
        panels.addElement(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.blocknamePanel = new JPanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add((Component)this.blocknamePanel, gbc);
        this.paramPane = new JPanel();
        this.paramPane.setLayout(new BorderLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.paramPane, gbc);
        this.add(this.paramPane);
        this.globalParamPane = new JPanel();
        this.globalParamPane.setLayout(new ToolBarLayout(0, 20, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gridBagLayout.setConstraints(this.globalParamPane, gbc);
        this.add(this.globalParamPane);
        this.actualPane = new JPanel();
        this.actualPane.setLayout(new BorderLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gridBagLayout.setConstraints(this.actualPane, gbc);
        this.add(this.actualPane);
    }

    protected final void addParameterPane(JComponent parameterPanel) {
        this.paramPane.add(parameterPanel);
    }

    public void addParamterPanelSourceChangedListener(ParameterPanelSourceChangedListener ppscl) {
        if (!this.getParameterPanelSourceChangedListeners().contains(ppscl)) {
            this.getParameterPanelSourceChangedListeners().add(ppscl);
        }
    }

    public void removeParameterPanelSourceChangedListener(ParameterPanelSourceChangedListener ppscl) {
        this.getParameterPanelSourceChangedListeners().remove(ppscl);
    }

    public void fireParameterPanelSourceChangedEvent(Block newSource) {
        Vector clone = (Vector)this.getParameterPanelSourceChangedListeners().clone();
        Enumeration e = clone.elements();
        while (e.hasMoreElements()) {
            ((ParameterPanelSourceChangedListener)e.nextElement()).parameterPanelSourceChanged(this, newSource);
        }
    }

    public Vector getParameterPanelSourceChangedListeners() {
        if (this.fParameterPanelSourceChangedListeners == null) {
            this.fParameterPanelSourceChangedListeners = new Vector(2);
        }
        return this.fParameterPanelSourceChangedListeners;
    }

    public static Vector createPanels(Parameter parameterReference, boolean simulationMode) throws IOException {
        Vector panels = new Vector();
        String panelClassName = "";
        String parameterClassName = parameterReference.getClass().getName();
        StringTokenizer st = new StringTokenizer(parameterClassName, ".");
        while (st.hasMoreTokens()) {
            panelClassName = st.nextToken();
        }
        panelClassName = parameterClassName.startsWith("DE.siemens.ad.kop.model") ? "DE.siemens.ad.kop.model.panel." + panelClassName.substring(0, panelClassName.length() - 9) + "Panel" : "DE.siemens.ad.logo.model.panel." + panelClassName.substring(0, panelClassName.length() - 9) + "Panel";
        CodeBlock exe = new CodeBlock(panelClassName);
        exe.addParameter(panels);
        try {
            exe.addParameter("DE.siemens.ad.logo.model.Parameter", parameterReference);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        exe.addParameter(simulationMode);
        try {
            exe.execConstructor();
        }
        catch (NoSuchMethodException e) {
            Exception ie = exe.getInternalException();
            ie.printStackTrace();
            if (ie instanceof InvocationTargetException) {
                ((InvocationTargetException)ie).getTargetException().printStackTrace();
            }
            throw new IOException("Class " + panelClassName + " does not seem to have the requested constructor or an Error within the Constructor occured.");
        }
        return panels;
    }

    public String getPanelName() {
        return this.fPanelName;
    }

    public Parameter getParameterReference() {
        return this.fParameterReference;
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public String getTitle() {
        return this.getPanelName();
    }

    public void setPanelName(String name) {
        this.fPanelName = name;
    }
}

